/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.init;

import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import net.creeperhost.chickens.handler.ItemHolder;
import net.creeperhost.chickens.handler.SpawnType;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ModChickens {
    public static List<ChickensRegistryItem> generateDefaultChickens() {
        ArrayList<ChickensRegistryItem> chickens = new ArrayList<ChickensRegistryItem>();
        chickens.add(new ChickensRegistryItem(ChickensRegistry.SMART_CHICKEN_ID, "smart_chicken", new ResourceLocation("chickens", "textures/entity/smart_chicken.png"), new ItemStack((ItemLike)Items.f_42521_), 0xFFFFFF, 0xFFFF00).setSpawnType(SpawnType.NONE));
        ChickensRegistryItem whiteChicken = ModChickens.createDyeChicken(DyeColor.WHITE, "white_chicken").setDropItem(new ItemStack((ItemLike)Items.f_42500_)).setSpawnType(SpawnType.NORMAL);
        chickens.add(whiteChicken);
        ChickensRegistryItem yellowChicken = ModChickens.createDyeChicken(DyeColor.YELLOW, "yellow_chicken");
        chickens.add(yellowChicken);
        ChickensRegistryItem blueChicken = ModChickens.createDyeChicken(DyeColor.BLUE, "blue_chicken");
        chickens.add(blueChicken);
        ChickensRegistryItem greenChicken = ModChickens.createDyeChicken(DyeColor.GREEN, "green_chicken");
        chickens.add(greenChicken);
        ChickensRegistryItem redChicken = ModChickens.createDyeChicken(DyeColor.RED, "red_chicken");
        chickens.add(redChicken);
        ChickensRegistryItem blackChicken = ModChickens.createDyeChicken(DyeColor.BLACK, "black_chicken");
        chickens.add(blackChicken);
        ChickensRegistryItem pinkChicken = ModChickens.createDyeChicken(DyeColor.PINK, "pink_chicken").setParentsNew(redChicken, whiteChicken);
        chickens.add(pinkChicken);
        ChickensRegistryItem purpleChicken = ModChickens.createDyeChicken(DyeColor.PURPLE, "purple_chicken").setParentsNew(blueChicken, redChicken);
        chickens.add(purpleChicken);
        chickens.add(ModChickens.createDyeChicken(DyeColor.ORANGE, "orange_chicken").setParentsNew(redChicken, yellowChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.LIGHT_BLUE, "light_blue_chicken").setParentsNew(whiteChicken, blueChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.LIME, "lime_chicken").setParentsNew(greenChicken, whiteChicken));
        ChickensRegistryItem grayChicken = ModChickens.createDyeChicken(DyeColor.GRAY, "gray_chicken").setParentsNew(blackChicken, whiteChicken);
        chickens.add(grayChicken);
        chickens.add(ModChickens.createDyeChicken(DyeColor.CYAN, "cyan_chicken").setParentsNew(blueChicken, greenChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.LIGHT_GRAY, "light_gray_chicken").setParentsNew(grayChicken, whiteChicken));
        chickens.add(ModChickens.createDyeChicken(DyeColor.MAGENTA, "magenta_chicken").setParentsNew(purpleChicken, pinkChicken));
        ChickensRegistryItem flintChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "flint_chicken"), "flint_chicken", new ResourceLocation("chickens", "textures/entity/flint_chicken.png"), new ItemStack((ItemLike)Items.f_42484_), 7039815, 10724213);
        chickens.add(flintChicken);
        ChickensRegistryItem quartzChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "quartz_chicken"), "quartz_chicken", new ResourceLocation("chickens", "textures/entity/quartz_chicken.png"), new ItemStack((ItemLike)Items.f_42692_), 0x4D0000, 0x1A0000).setSpawnType(SpawnType.HELL);
        chickens.add(quartzChicken);
        ChickensRegistryItem logChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "log_chicken"), "log_chicken", new ResourceLocation("chickens", "textures/entity/log_chicken.png"), new ItemStack((ItemLike)Blocks.f_49999_), 9995373, 5407576);
        chickens.add(logChicken);
        ChickensRegistryItem sandChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "sand_chicken"), "sand_chicken", new ResourceLocation("chickens", "textures/entity/sand_chicken.png"), new ItemStack((ItemLike)Blocks.f_49992_), 15525297, 10985580);
        chickens.add(sandChicken);
        ChickensRegistryItem stringChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "string_chicken"), "string_chicken", new ResourceLocation("chickens", "textures/entity/string_chicken.png"), new ItemStack((ItemLike)Items.f_42401_), 3348992, 0x800000, blackChicken, logChicken).setDropItem(new ItemStack((ItemLike)Items.f_42591_));
        chickens.add(stringChicken);
        ChickensRegistryItem glowstoneChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "glowstone_chicken"), "glowstone_chicken", new ResourceLocation("chickens", "textures/entity/glowstone_chicken.png"), new ItemStack((ItemLike)Items.f_42525_), 0xFFFF66, 0xFFFF00, quartzChicken, yellowChicken);
        chickens.add(glowstoneChicken);
        ChickensRegistryItem gunpowderChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "gunpowder_chicken"), "gunpowder_chicken", new ResourceLocation("chickens", "textures/entity/gunpowder_chicken.png"), new ItemStack((ItemLike)Items.f_42403_), 0x999999, 0x404040, sandChicken, flintChicken);
        chickens.add(gunpowderChicken);
        ChickensRegistryItem redstoneChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "redstone_chicken"), "redstone_chicken", new ResourceLocation("chickens", "textures/entity/redstone_chicken.png"), new ItemStack((ItemLike)Items.f_42451_), 0xE60000, 0x800000, redChicken, sandChicken);
        chickens.add(redstoneChicken);
        ChickensRegistryItem glassChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "glass_chicken"), "glass_chicken", new ResourceLocation("chickens", "textures/entity/glass_chicken.png"), new ItemStack((ItemLike)Blocks.f_50058_), 0xFFFFFF, 0xEEEEFF, quartzChicken, redstoneChicken);
        chickens.add(glassChicken);
        ChickensRegistryItem ironChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "iron_chicken"), "iron_chicken", new ResourceLocation("chickens", "textures/entity/iron_chicken.png"), new ItemStack((ItemLike)Items.f_42416_), 0xFFFFCC, 0xFFCCCC, flintChicken, whiteChicken);
        chickens.add(ironChicken);
        ChickensRegistryItem coalChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "coal_chicken"), "coal_chicken", new ResourceLocation("chickens", "textures/entity/coal_chicken.png"), new ItemStack((ItemLike)Items.f_42413_), 0x262626, 0, flintChicken, logChicken);
        chickens.add(coalChicken);
        ChickensRegistryItem brownChicken = ModChickens.createDyeChicken(DyeColor.BROWN, "brown_chicken").setParentsNew(redChicken, greenChicken);
        chickens.add(brownChicken);
        ChickensRegistryItem goldChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "gold_chicken"), "gold_chicken", new ResourceLocation("chickens", "textures/entity/gold_chicken.png"), new ItemStack((ItemLike)Items.f_42587_), 0xCCCC00, 0xFFFF80, ironChicken, yellowChicken);
        chickens.add(goldChicken);
        ChickensRegistryItem snowballChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "snowball_chicken"), "snowball_chicken", new ResourceLocation("chickens", "textures/entity/snowball_chicken.png"), new ItemStack((ItemLike)Items.f_42452_), 0x33BBFF, 35020, blueChicken, logChicken).setSpawnType(SpawnType.SNOW);
        chickens.add(snowballChicken);
        ChickensRegistryItem waterChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "water_chicken"), "water_chicken", new ResourceLocation("chickens", "textures/entity/water_chicken.png"), new ItemHolder("chickens:liquid_egg", "{id:\"minecraft:water\"}"), 153, 0x8080FF, gunpowderChicken, snowballChicken);
        chickens.add(waterChicken);
        ChickensRegistryItem lavaChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "lava_chicken"), "lava_chicken", new ResourceLocation("chickens", "textures/entity/lava_chicken.png"), new ItemHolder("chickens:liquid_egg", "{id:\"minecraft:lava\"}"), 0xCC3300, 0xFFFF00, coalChicken, quartzChicken).setSpawnType(SpawnType.HELL);
        chickens.add(lavaChicken);
        ChickensRegistryItem clayChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "clay_chicken"), "clay_chicken", new ResourceLocation("chickens", "textures/entity/clay_chicken.png"), new ItemStack((ItemLike)Items.f_42461_), 0xCCCCCC, 0xBFBFBF, snowballChicken, sandChicken);
        chickens.add(clayChicken);
        ChickensRegistryItem leatherChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "leather_chicken"), "leather_chicken", new ResourceLocation("chickens", "textures/entity/leather_chicken.png"), new ItemStack((ItemLike)Items.f_42454_), 10985580, 0x919191, stringChicken, brownChicken);
        chickens.add(leatherChicken);
        ChickensRegistryItem netherwartChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "netherwart_chicken"), "netherwart_chicken", new ResourceLocation("chickens", "textures/entity/netherwart_chicken.png"), new ItemStack((ItemLike)Items.f_42588_), 0x800000, 3348992, brownChicken, glowstoneChicken);
        chickens.add(netherwartChicken);
        ChickensRegistryItem diamondChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "diamond_chicken"), "diamond_chicken", new ResourceLocation("chickens", "textures/entity/diamond_chicken.png"), new ItemStack((ItemLike)Items.f_42415_), 0x99CCFF, 15135487, glassChicken, goldChicken);
        chickens.add(diamondChicken);
        ChickensRegistryItem blazeChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "blaze_chicken"), "blaze_chicken", new ResourceLocation("chickens", "textures/entity/blaze_chicken.png"), new ItemStack((ItemLike)Items.f_42585_), 0xFFFF66, 0xFF3300, goldChicken, lavaChicken);
        chickens.add(blazeChicken);
        ChickensRegistryItem slimeChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "slime_chicken"), "slime_chicken", new ResourceLocation("chickens", "textures/entity/slime_chicken.png"), new ItemStack((ItemLike)Items.f_42518_), 39219, 0x99FFBB, clayChicken, greenChicken);
        chickens.add(slimeChicken);
        ChickensRegistryItem enderChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "ender_chicken"), "ender_chicken", new ResourceLocation("chickens", "textures/entity/ender_chicken.png"), new ItemStack((ItemLike)Items.f_42584_), 6656, 6707, diamondChicken, netherwartChicken);
        chickens.add(enderChicken);
        ChickensRegistryItem ghastChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "ghast_chicken"), "ghast_chicken", new ResourceLocation("chickens", "textures/entity/ghast_chicken.png"), new ItemStack((ItemLike)Items.f_42586_), 0xFFFFCC, 0xFFFFFF, whiteChicken, blazeChicken);
        chickens.add(ghastChicken);
        ChickensRegistryItem emeraldChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "emerald_chicken"), "emerald_chicken", new ResourceLocation("chickens", "textures/entity/emerald_chicken.png"), new ItemStack((ItemLike)Items.f_42616_), 52224, 13056, diamondChicken, greenChicken);
        chickens.add(emeraldChicken);
        ChickensRegistryItem magmaChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "magma_chicken"), "magma_chicken", new ResourceLocation("chickens", "textures/entity/magma_chicken.png"), new ItemStack((ItemLike)Items.f_42542_), 1705216, 0, slimeChicken, blazeChicken);
        chickens.add(magmaChicken);
        ChickensRegistryItem pShardChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "pshard_chicken"), "pshard_chicken", new ResourceLocation("chickens", "textures/entity/pshard_chicken.png"), new ItemStack((ItemLike)Items.f_42695_), 4423790, 10472380, waterChicken, blueChicken);
        chickens.add(pShardChicken);
        ChickensRegistryItem pCrystalChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "pcrystal_chicken"), "pcrystal_chicken", new ResourceLocation("chickens", "textures/entity/pcrystal_chicken.png"), new ItemStack((ItemLike)Items.f_42696_, 1), 5138785, 14674396, waterChicken, emeraldChicken);
        chickens.add(pCrystalChicken);
        ChickensRegistryItem obsidianChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "obsidian_chicken"), "obsidian_chicken", new ResourceLocation("chickens", "textures/entity/obsidian_chicken.png"), new ItemStack((ItemLike)Blocks.f_50080_, 1), 526350, 4602464, waterChicken, lavaChicken);
        chickens.add(obsidianChicken);
        ChickensRegistryItem soulSandChicken = new ChickensRegistryItem(new ResourceLocation("chickens", "soulsand_chicken"), "soulsand_chicken", new ResourceLocation("chickens", "textures/entity/soulsand_chicken.png"), new ItemStack((ItemLike)Blocks.f_50135_, 1), 4534565, 13971208).setSpawnType(SpawnType.HELL);
        chickens.add(soulSandChicken);
        return chickens;
    }

    @Deprecated
    public static ChickensRegistryItem createDyeChicken(DyeColor color, String name) {
        DyeItem dyeItem = DyeItem.m_41082_((DyeColor)color);
        return new ChickensRegistryItem(new ResourceLocation("chickens", name), name, new ResourceLocation("chickens", "textures/entity/" + Strings.join((String[])name.split("(?=[A-Z])"), (String)"_").toLowerCase() + ".png"), new ItemStack((ItemLike)dyeItem, 1), 0xF2F2F2, ModChickens.getRGB(color)).setSpawnType(SpawnType.NONE);
    }

    public static int getRGB(DyeColor color) {
        return color.m_41071_();
    }
}

